package com.sap.idm.vds.connector.samplefile.impl;

/**
 * Class that contains the constants used for the API
 * @author I054742
 *
 */
public class FileConstants {
	
	/* Constants for options */
	public final static int BASE_SEARCH = 0;
	public final static int ONE_LEVEL_SEARCH = 1;
	public final static int SUBTREE_SEARCH = 2;
	public final static int REPLACE = 2;
	public final static int DELETE = 1;
	public final static int APPEND = 0;
	
	/* Constants for errors */
	public final static int SUCCESS = 0;
	public final static int INVALID_OPTION = 1;
	public final static int ERROR = 2;
	public final static int FILE_NOT_FOUND = 3;
	public final static int WRONG_DN_FILE_TYPE = 4;
	public final static int PROHIBIT_DELETE_BRANCHES = 5;
	public final static int FILE_ALREADY_EXISTS = 6;
	public final static int WRONG_PATH_CREATION_POINT = 7;
	public final static int WRONG_FILE_TYPE = 8;
	public final static int IO_ERROR = 9;
	public final static int NULL_STRING = 10;
	
	/* Error messages */
	public final static String [] MESSAGES = 
			{	"Success",
				"Invalid Option for this Operation",
				"Error",
				"File Not Found",
				"The DN file type is not the same than the real file type in the system",
				"To delete nodes which contain child nodes is a prohibited operation",
				"The file already exists",
				"The node where you want to add the new object is not a suitable node for it",
				"The operation is not permitted for this type of file",
				"IO Error",
				"Null String Detected"
			};
	
	/* Associated LDAP error codes */
	public final static int [] LDAP_CODES = 
			{	0, 
				21,
				1,
				32,
				34,
				1,
				68,
				32,
				34,
				1,
				1
			};
}
